@extends('layouts.admin')

@section('body')
    <style>
        tr,
        td,
        th {
            padding: 5px 15px !important;
        }
    </style>
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Kuisioner</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('home') }}"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Master</a></li>
                        <li class="breadcrumb-item"><a href="#!">Kuisioner</a></li>
                    </ul>
                </div>
                @if (Session::has('message'))
                    <div class="col-md-6">
                        <div class="alert {{ Session::get('alert') }} alert-dismissible fade show mb-0" role="alert">
                            <strong>{{ Session::get('message') }}</strong>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
    <!-- [ breadcrumb ] end -->
    <!-- [ Main Content ] start -->
    <div class="row">
        <!-- [ sample-page ] start -->
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-10">
                            <h5>
                                Data Kuisioner
                            </h5>
                        </div>
                        <div class="col-md-2">
                            <div class="text-right">
                                {{-- <button class="btn btn-success btn-sm" data-toggle="modal"
                                    data-target="#modalTambah">Tambah</button> --}}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        @foreach ($data as $key => $d)
                            @php
                                $d->crypt = Crypt::encrypt($d->id);
                            @endphp
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <h3>{{ $d->urutan }}. {{ $d->jenis }}</h3>
                                                <img src="<?= $d->foto != null && $d->foto != '' ? asset($d->foto) : asset('asset/img/6.jpg') ?>"
                                                    class="card-img-top" alt="Foto {{ $d->name }}">
                                                <p>{{ $d->deskripsi }}</p>
                                                <a href="#" class="badge badge-warning" data-toggle="modal"
                                                    data-target="#modalEdit" onclick="editData('{{ $d->crypt }}')"><i
                                                        class="fas fa-pencil-alt"></i>
                                                    Edit</a>
                                                {{-- <a href="#" class="badge badge-danger" data-toggle="modal"
                                                    data-target="#modalHapus" onclick="hapusData('{{ $d->crypt }}')"><i
                                                        class="fas fa-trash-alt"></i>
                                                    Hapus</a> --}}
                                            </div>
                                            <div class="col-md-9">

                                                <a href="#" class="badge badge-success" data-toggle="modal"
                                                    data-target="#modalTambahJawaban"
                                                    onclick="tambahJawaban('{{ $d->crypt }}')"><i
                                                        class="fas fa-plus"></i>
                                                    Tambah Jawaban</a>
                                                <br>
                                                <table class="table">
                                                    <tr class="table-secondary">
                                                        <th>No</th>
                                                        <th>Deskripsi</th>
                                                        <th>Jawaban</th>
                                                        <th></th>
                                                    </tr>
                                                    @foreach ($d->jawaban as $kay => $j)
                                                        <tr>
                                                            <td>{{ $j->urutan }}</td>
                                                            <td class="wrapdata">{{ $j->deskripsi }}</td>
                                                            <td class="wrapdata">
                                                                @foreach ($j->kopi as $kuy => $k)
                                                                    {{ $k->name }},
                                                                @endforeach
                                                            </td>
                                                            <td>
                                                                <a href="#" class="badge badge-warning"
                                                                    data-toggle="modal" data-target="#modalEditJawaban"
                                                                    onclick="editData('{{ $j->crypt }}')"><i
                                                                        class="fas fa-pencil-alt"></i>
                                                                    Edit</a>
                                                                <a href="#" class="badge badge-danger"
                                                                    data-toggle="modal" data-target="#modalJawabanHapus"
                                                                    onclick="hapusData('{{ $j->crypt }}')"><i
                                                                        class="fas fa-trash-alt"></i>
                                                                    Hapus</a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </table>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                </div>
            </div>
        </div>
        <!-- [ sample-page ] end -->
    </div>
    <!-- [ Main Content ] end -->

    {{-- MODAL TAMBAH JAWABAN --}}
    <div id="modalTambahJawaban" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalTambahJawabanLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTambahJawabanLabel">Tambah Jawaban</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>
                <form action="{{ url('admin/kopi') }}" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        @csrf
                        <div class="form-group">
                            <label class="floating-label" for="Text">Jenis Kuisioner</label>
                            <select class="form-control select2" name="jenis_kuisioner" id="jenis_kuisioner">
                                @foreach ($data as $key => $k)
                                    <option value="{{ $k->id }}">{{ $k->jenis }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Urutan</label>
                            <input type="number" class="form-control" id="urutan" name="urutan"
                                placeholder="Urutan">
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Deskripsi</label>
                            <textarea class="form-control" id="deskripsi" name="deskripsi" placeholder="Deskripsi" rows="2"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Kopi</label>
                            <select class="form-control select2" name="kopi" id="kopi" multiple>
                                @foreach ($kopi as $key => $k)
                                    <option value="{{ $k->id }}">{{ $k->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="file">foto</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="file" name="file">
                                <label class="custom-file-label" for="file">Choose file</label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Warna</label>
                            <input type="text" class="form-control" id="warna" name="warna"
                                placeholder="#FFFFFF">
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- MODAL TAMBAH JAWABAN END --}}

    {{-- MODAL EDIT JAWABAN --}}
    <div id="modalEditJawaban" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalEditJawabanLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditJawabanLabel">Edit Jawaban</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>
                <form action="{{ url('admin/kopi') }}" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        @csrf
                        <div class="form-group">
                            <label class="floating-label" for="Text">Jenis Kuisioner</label>
                            <select class="form-control select2" name="editj_jenis_kuisioner" id="jenis_kuisioner">
                                @foreach ($data as $key => $k)
                                    <option value="{{ $k->id }}">{{ $k->jenis }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Urutan</label>
                            <input type="number" class="form-control" id="editj_urutan" name="urutan"
                                placeholder="Urutan">
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Deskripsi</label>
                            <textarea class="form-control" id="editj_deskripsi" name="deskripsi" placeholder="Deskripsi" rows="2"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Kopi</label>
                            <select class="form-control select2" name="kopi" id="editj_kopi" multiple>
                                @foreach ($kopi as $key => $k)
                                    <option value="{{ $k->id }}">{{ $k->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="file">foto</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="editj_file" name="file">
                                <label class="custom-file-label" for="file">Choose file</label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Warna</label>
                            <input type="text" class="form-control" id="editj_warna" name="warna"
                                placeholder="#FFFFFF">
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- MODAL EDIT JAWABAN END --}}

    {{-- MODAL TAMBAH --}}
    <div id="modalTambah" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalTambahLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTambahLabel">Tambah Kuisioner</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>
                <form action="{{ url('admin/kopi') }}" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        @csrf
                        <div class="form-group">
                            <label class="floating-label" for="Text">Jenis Kuisioner</label>
                            <input type="text" class="form-control" id="jenis" name="jenis"
                                placeholder="Nama Kopi">
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Urutan</label>
                            <input type="number" class="form-control" id="urutan" name="urutan"
                                placeholder="Nama Kopi">
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Deskripsi</label>
                            <textarea class="form-control" id="deskripsi" name="deskripsi" placeholder="Deskripsi" rows="2"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="file">Background</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="file" name="file">
                                <label class="custom-file-label" for="file">Choose file</label>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- MODAL TAMBAH END --}}

    {{-- MODAL EDIT --}}
    <div id="modalEdit" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalEditLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit <u id="nama_edit">-</u></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>
                <form id="formEdit" action="#" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        {{ csrf_field() }}
                        {{ method_field('PUT') }}
                        <div class="form-group">
                            <label class="floating-label" for="Text">Jenis Kuisioner</label>
                            <input type="text" class="form-control" id="edit_jenis" name="jenis"
                                placeholder="Nama Kopi">
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Urutan</label>
                            <input type="number" class="form-control" id="edit_urutan" name="urutan"
                                placeholder="Nama Kopi">
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Deskripsi</label>
                            <textarea class="form-control" id="edit_deskripsi" name="deskripsi" placeholder="Deskripsi" rows="2"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="file">Background</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="edit_file" name="file">
                                <label class="custom-file-label" for="file">Choose file</label>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-warning">Update Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- MODAL edit END --}}

    {{-- MODAL HAPUS --}}
    <div id="modalHapus" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalHapusLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form id="formHapus" action="#" method="post">
                    <div class="modal-body">
                        {{ csrf_field() }}
                        {{ method_field('DELETE') }}
                        <p style="font-size: 18px">Hapus Data <b><u id="nama_hapus">-</u></b> ?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-danger">Hapus Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- MODAL HAPUS END --}}
@endsection

@section('javascript')
    <script>
        function hapusData(id) {
            $.get(`{{ url('admin/kuisioner') }}/${id}`, function(data, status) {
                $("#nama_hapus").text(data.name);
            });
            $("#formHapus").prop("action", `{{ url('admin/kuisioner') }}/${id}`);
        }

        function editData(id) {
            $.get(`{{ url('admin/kuisioner') }}/${id}/edit`, function(data, status) {
                $("#nama_edit").text(data.jenis);
                $("#edit_jenis").val(data.jenis);
                $("#edit_urutan").val(data.urutan);
                $("#edit_deskripsi").val(data.deskripsi);
            });
            $("#formEdit").prop("action", `{{ url('admin/kuisioner') }}/${id}`);
        }
    </script>
@endsection
