@extends('layouts.admin')

@section('body')
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Dashboard</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('home') }}"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ url('home') }}">Home</a></li>
                        {{-- <li class="breadcrumb-item"><a href="#!">Kategori</a></li> --}}
                    </ul>
                </div>
                @if (Session::has('message'))
                    <div class="col-md-6">
                        <div class="alert {{ Session::get('alert') }} alert-dismissible fade show mb-0" role="alert">
                            <strong>{{ Session::get('message') }}</strong>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
    <!-- [ breadcrumb ] end -->
    <!-- [ Main Content ] start -->
    <div class="row">
        <!-- [ sample-page ] start -->
        <div class="col-sm-12">

        </div>
        <!-- [ sample-page ] end -->
    </div>
    <!-- [ Main Content ] end -->
@endsection

@section('javascript')
    <script>
        function hapusData(id) {
            $.get(`{{ url('admin/kategori') }}/${id}`, function(data, status) {
                $("#nama_hapus").text(data.name);
            });
            $("#formHapus").prop("action", `{{ url('admin/kategori') }}/${id}`);
        }

        function editData(id) {
            $.get(`{{ url('admin/kategori') }}/${id}/edit`, function(data, status) {
                console.log(data);
                $("#nama_edit").text(data.name);
                $("#edit_name").val(data.name);
                $("#edit_jenis").val(data.jenis);
                $("#edit_penanggung_jawab").val(data.penanggung_jawab).trigger("change");
                $("#edit_master_kategori").val(data.master_kategori).trigger("change");
                $("#edit_status").val(data.status);
            });
            $("#formEdit").prop("action", `{{ url('admin/kategori') }}/${id}`);
        }
    </script>
@endsection
