<?php $__env->startSection('body'); ?>
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Master Kopi</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('home')); ?>"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Master</a></li>
                        <li class="breadcrumb-item"><a href="#!">Kopi</a></li>
                    </ul>
                </div>
                <?php if(Session::has('message')): ?>
                    <div class="col-md-6">
                        <div class="alert <?php echo e(Session::get('alert')); ?> alert-dismissible fade show mb-0" role="alert">
                            <strong><?php echo e(Session::get('message')); ?></strong>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- [ breadcrumb ] end -->
    <!-- [ Main Content ] start -->
    <div class="row">
        <!-- [ sample-page ] start -->
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-10">
                            <h5>
                                Data Kopi
                            </h5>
                        </div>
                        <div class="col-md-2">
                            <div class="text-right">
                                <button class="btn btn-success btn-sm" data-toggle="modal"
                                    data-target="#modalTambah">Tambah</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $d->crypt = Crypt::encrypt($d->id);
                            ?>
                            <div class="col-md-3 col-sm-4 col-6">
                                <div class="card">
                                    <img src="<?= $d->foto != null && $d->foto != '' ? asset($d->foto) : asset('asset/img/4.jpg') ?>"
                                        class="card-img-top" alt="Foto <?php echo e($d->name); ?>">
                                    <div class="card-body">
                                        <h5 class="card-title"><?php echo e($d->name); ?></h5>
                                        



                                        <br>
                                        <a href="#" class="badge badge-warning" data-toggle="modal"
                                            data-target="#modalEdit" onclick="editData('<?php echo e($d->crypt); ?>')"><i
                                                class="fas fa-pencil-alt"></i>
                                            Edit</a>
                                        <a href="#" class="badge badge-danger" data-toggle="modal"
                                            data-target="#modalHapus" onclick="hapusData('<?php echo e($d->crypt); ?>')"><i
                                                class="fas fa-trash-alt"></i>
                                            Hapus</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                </div>
            </div>
        </div>
        <!-- [ sample-page ] end -->
    </div>
    <!-- [ Main Content ] end -->

    
    <div id="modalTambah" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalTambahLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTambahLabel">Tambah Kopi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>
                <form action="<?php echo e(url('admin/kopi')); ?>" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label class="floating-label" for="Text">Nama</label>
                            <input type="text" class="form-control" id="name" name="name"
                                placeholder="Nama Kopi">
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="file">Foto (jpg/png Ratio 1:1)</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="file" name="file">
                                <label class="custom-file-label" for="file">Choose file</label>
                            </div>
                        </div>

                        

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    

    
    <div id="modalEdit" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalEditLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Role <u id="nama_edit">-</u></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>
                <form id="formEdit" action="#" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <?php echo e(csrf_field()); ?>

                        <?php echo e(method_field('PUT')); ?>

                        <div class="form-group">
                            <label class="floating-label" for="Text">Nama</label>
                            <input type="text" class="form-control" id="edit_name" name="edit_name"
                                placeholder="Nama Kopi">
                        </div>
                        <div class="form-group">
                            <label class="floating-label" for="file">Foto (jpg/png Ratio 1:1) Kosongi jika tidak di
                                ubah</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="edit_file" name="edit_file">
                                <label class="custom-file-label" for="file">Choose file</label>
                            </div>
                        </div>

                        

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-warning">Update Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    

    
    <div id="modalHapus" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalHapusLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form id="formHapus" action="#" method="post">
                    <div class="modal-body">
                        <?php echo e(csrf_field()); ?>

                        <?php echo e(method_field('DELETE')); ?>

                        <p style="font-size: 18px">Hapus Data <b><u id="nama_hapus">-</u></b> ?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-sm btn-danger">Hapus Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        function hapusData(id) {
            $.get(`<?php echo e(url('admin/kopi')); ?>/${id}`, function(data, status) {
                $("#nama_hapus").text(data.name);
            });
            $("#formHapus").prop("action", `<?php echo e(url('admin/kopi')); ?>/${id}`);
        }

        function editData(id) {
            $.get(`<?php echo e(url('admin/kopi')); ?>/${id}/edit`, function(data, status) {
                $("#nama_edit").text(data.name);
                $("#edit_name").val(data.name);
                $("#edit_l_toped").val(data.l_toped);
                $("#edit_l_shopee").val(data.l_shopee);
                $("#edit_l_tiktok").val(data.l_tiktok);
                $("#edit_l_lazada").val(data.l_lazada);
                $("#edit_l_bukalapak").val(data.l_bukalapak);
                $("#edit_l_wa").val(data.l_wa);
            });
            $("#formEdit").prop("action", `<?php echo e(url('admin/kopi')); ?>/${id}`);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\jjroyal2\resources\views/kopi.blade.php ENDPATH**/ ?>