<?php

namespace App\Http\Controllers;
use Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

use App\Models\m_kopies;
use App\Models\m_kuisioners;
use App\Models\m_jawabans;

class kuisionerController extends Controller
{
    public function index()
    {
        $data = m_kuisioners::where('del',0)->orderBy('urutan','ASC')->get();
        foreach ($data as $key => $d) {
            $d->jawaban = m_jawabans::where('del',0)->where('jenis_id',$d->id)->orderBy('urutan','ASC')->get();
            foreach ($d->jawaban as $kay => $e) {
                $kk = explode(',',$e->kopi);
                $e->kopi = m_kopies::whereIn('id',$kk)->get();
            }
        }
        $kopi = m_kopies::where('del',0)->get();

        return view('m_kuisioner', compact('data','kopi'));
    }

    public function edit($id)
    {
        $idku = Crypt::decrypt($id);
        $find = m_kuisioners::find($idku);
        $find->crypt = $id;
        return response()->json($find);
    }

    public function update(Request $request, $id)
    {
        $id = Crypt::decrypt($id);
        $forms = $request->all();

        $validator = Validator::make($forms, [
            'jenis' => 'required',
            'urutan' => 'required',
            'deskripsi' => 'required',
        ]);
        if($validator->fails()){
            \Session::flash('alert', 'alert-danger');
			\Session::flash('message', 'Gagal, Data Tidak Lengkap');
            return redirect('admin/kuisioner');
        }else{
            $find = m_kuisioners::find($id);

            if(isset($forms['file'])){
                $file = $request->file('file');
                $ekstensi = strtolower($file->getClientOriginalExtension());
                if ($ekstensi == 'png' || $ekstensi == 'jpg' || $ekstensi == 'jpeg') {
                    if ($file->getSize() <= 8000000) {
                        $tujuan = 'upload/kuisioner/';
                        $forms['file'] = $this->__GenerateRandomName().'_'.date('YmdHi').'.'.$ekstensi;
                        $file->move($tujuan,$forms['file']);
                        $forms['foto'] = $tujuan.'/'.$forms['file'];
                    }else{
                        \Session::flash('alert', 'alert-danger');
                        \Session::flash('message', 'Maaf, Ukuran Dokumen Lebih Dari 8MB');
                        return redirect('admin/kuisioner');
                    }
                }else{
                    \Session::flash('alert', 'alert-danger');
                    \Session::flash('message', 'Maaf, Dokumen Bukan Berformat pdf/image');
                    return redirect('admin/kuisioner');
                }
            }else{
                $forms['foto'] = $find->foto;
            }

            $ubah['jenis'] = $forms['jenis'];
            $ubah['urutan'] = $forms['urutan'];
            $ubah['deskripsi'] = $forms['deskripsi'];
            $ubah['foto'] = $forms['foto'];

            $find->update($ubah);
            \Session::flash('alert', 'alert-success');
            \Session::flash('message', 'Berhasil, Data Telah Diupdate');
        }
        return redirect('admin/kuisioner');
    }


}
